/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.skill;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IProgressData;
import dev.toma.gunsrpg.client.screen.skill.IViewContext;
import dev.toma.gunsrpg.client.screen.skill.IViewManager;
import dev.toma.gunsrpg.client.screen.skill.PerkView;
import dev.toma.gunsrpg.client.screen.skill.SkillTreeScreen;
import dev.toma.gunsrpg.client.screen.skill.SkillTrees;
import dev.toma.gunsrpg.client.screen.skill.SkillViewData;
import dev.toma.gunsrpg.client.screen.skill.Tree;
import dev.toma.gunsrpg.client.screen.skill.View;
import dev.toma.gunsrpg.client.screen.widgets.FooterWidget;
import dev.toma.gunsrpg.client.screen.widgets.HeaderWidget;
import dev.toma.gunsrpg.client.screen.widgets.LineWidget;
import dev.toma.gunsrpg.client.screen.widgets.NavigatorWidget;
import dev.toma.gunsrpg.client.screen.widgets.PannableWidget;
import dev.toma.gunsrpg.client.screen.widgets.SkillInfoWidget;
import dev.toma.gunsrpg.client.screen.widgets.SkillWidget;
import dev.toma.gunsrpg.client.screen.widgets.ViewSwitchWidget;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.skills.core.SkillCategory;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.math.IVec2i;
import dev.toma.gunsrpg.util.math.Mth;
import dev.toma.gunsrpg.util.math.Vec2iMutable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lib.toma.animations.Easings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SkillsView
extends View {
    private NavigatorWidget<SkillCategory> navigatorWidget;
    private PannableWidget skillViewWidget;
    private FooterWidget footerWidget;
    private SkillInfoWidget skillInfoWidget;
    private ViewSwitchWidget viewSwitchWidget;

    public SkillsView(int windowWidth, int windowHeight, IViewManager manager) {
        super(windowWidth, windowHeight, manager);
    }

    @Override
    protected void init() {
        this.clear();
        this.viewSwitchWidget = this.addWidget(new ViewSwitchWidget(this.field_230690_l_ + this.field_230688_j_ - 42, this.field_230689_k_ - 62, 32, 32, new ItemStack((IItemProvider)ModItems.PERKPOINT_BOOK)));
        this.viewSwitchWidget.setClickEvent(this::openPerkView);
        this.viewSwitchWidget.setColorSchema(16754188, 16765470);
        this.skillViewWidget = this.addWidget(new PannableWidget(this.field_230690_l_, this.field_230691_m_ + 40, this.field_230688_j_, this.field_230689_k_ - 60));
        this.skillViewWidget.setEmptyClickResponder(this::skillClicked);
        ITextComponent username = this.client.field_71439_g.func_200200_C_();
        TranslationTextComponent header = new TranslationTextComponent("view.skill.header", new Object[]{username.getString()});
        this.addWidget(new HeaderWidget(0, 0, this.field_230688_j_, 20, (ITextComponent)header, this.font));
        SkillCategory[] navEntries = (SkillCategory[])Arrays.stream(SkillCategory.values()).sorted((o1, o2) -> o2.ordinal() - o1.ordinal()).toArray(SkillCategory[]::new);
        this.navigatorWidget = this.addWidget(new NavigatorWidget<SkillCategory>(this.field_230690_l_, this.field_230691_m_ + 20, this.field_230688_j_, 20, navEntries));
        this.navigatorWidget.setTextFormatter(cat -> cat.name().toLowerCase(Locale.ROOT));
        this.navigatorWidget.setClickResponder(this::updateCanvasSource);
        this.navigatorWidget.setColorProvider(CategoryColorProvider::new);
        IViewContext context = this.manager.getContext();
        IPlayerData data = context.getData();
        IProgressData pointProvider = data.getProgressData();
        this.footerWidget = this.addWidget(new FooterWidget(this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - 20, this.field_230688_j_, 20, this.client.field_71466_p, pointProvider));
        this.footerWidget.setColorSchema(65535, 52428);
        this.skillInfoWidget = this.addWidget(new SkillInfoWidget(this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - 80, this.field_230688_j_, 80, this.manager));
        this.loadTree();
        this.updateSkillInformationVisibility(false);
    }

    public void loadTree() {
        this.updateCanvasSource(this.navigatorWidget.getSelectedValue());
    }

    @Override
    protected void renderView(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.renderView(stack, mouseX, mouseY, partialTicks);
    }

    private void openPerkView() {
        this.manager.setView(new PerkView(this.field_230688_j_, this.field_230689_k_, this.manager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCanvasSource(SkillCategory category) {
        if (!SkillTreeScreen.Cache.hasBeenBuilt()) {
            return;
        }
        this.updateSkillInformationVisibility(false);
        Map<SkillCategory, SkillTrees> map = SkillTreeScreen.Cache.queryData();
        SkillTrees skillTrees = map.get((Object)category);
        int xUnitSize = 6;
        int yUnitSize = 10;
        int componentSize = 22;
        int lineOff = componentSize / 2;
        IPlayerData data = this.manager.getContext().getData();
        IProgressData progressData = data.getProgressData();
        int level = progressData.getLevel();
        this.skillViewWidget.fill((filler, x, y) -> {
            Tree[] trees;
            for (Tree tree : trees = skillTrees.getTrees()) {
                for (Tree.Connector connector : tree.getConnectorList()) {
                    IVec2i start = connector.getStart();
                    IVec2i end = connector.getEnd();
                    filler.add(new LineWidget(x + start.x() * xUnitSize + lineOff, y + start.y() * yUnitSize + lineOff, x + end.x() * xUnitSize + lineOff, y + end.y() * yUnitSize + lineOff));
                }
                for (Map.Entry entry : tree.getDataSet()) {
                    SkillType source = (SkillType)((Object)((Object)entry.getKey()));
                    boolean invisible = source.getProperties().getRequiredLevel() > level;
                    SkillViewData viewData = (SkillViewData)entry.getValue();
                    Vec2iMutable pos = viewData.getPos();
                    SkillWidget widget = filler.add(new SkillWidget(x + pos.x() * xUnitSize, y + pos.y() * yUnitSize, componentSize, componentSize, source, this.manager.getContext(), invisible));
                    widget.setClickResponder(this::skillClicked);
                }
            }
        });
        Object object = this.lock;
        synchronized (object) {
            this.skillViewWidget.sortRenderOrder();
        }
    }

    private void skillClicked(SkillType<?> type) {
        this.skillInfoWidget.updateSource(type);
        this.updateSkillInformationVisibility(type != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSkillInformationVisibility(boolean visibilityState) {
        Object object = this.lock;
        synchronized (object) {
            this.footerWidget.field_230694_p_ = !visibilityState;
            this.viewSwitchWidget.field_230694_p_ = !visibilityState;
            this.skillInfoWidget.field_230694_p_ = visibilityState;
            this.skillViewWidget.updateSize(this.field_230688_j_, this.field_230689_k_ - (visibilityState ? 120 : 60));
        }
    }

    private static final class CategoryColorProvider
    implements NavigatorWidget.ITextColorProvider<SkillCategory> {
        private final SkillCategory category;
        private final Set<SkillType<?>> skills;
        private boolean hasNewSkills;
        private int animCounter;

        CategoryColorProvider(SkillCategory category) {
            this.category = category;
            this.skills = ModRegistries.SKILLS.getValues().stream().filter(skillType -> skillType.getHierarchy().getCategory().equals((Object)category)).collect(Collectors.toSet());
        }

        @Override
        public void tick(SkillCategory category) {
            this.hasNewSkills = false;
            for (SkillType<?> type : this.skills) {
                if (!type.isFresh()) continue;
                this.hasNewSkills = true;
                break;
            }
            this.animCounter = !this.hasNewSkills ? 0 : ++this.animCounter;
        }

        @Override
        public int getColor(SkillCategory categoryElement, float partialTicks) {
            if (!this.hasNewSkills) {
                return 0xFFFFFF;
            }
            int timer = this.animCounter % 40;
            float triangleFn = Mth.triangleFunc((float)timer / 40.0f);
            float easedWave = Easings.EASE_IN_OUT_QUAD.ease(triangleFn);
            int color = (int)(255.0f * (1.0f - easedWave));
            return 0xFFFF00 | color;
        }
    }
}

